/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.event;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.items.TCIntegrationHooks;
import tcintegrations.items.TCIntegrationsModifiers;
import tcintegrations.items.modifiers.hooks.IArmorCrouchModifier;
import tcintegrations.items.modifiers.hooks.IArmorJumpModifier;
import tcintegrations.network.LaunchGhostSword;
import tcintegrations.network.NetworkHandler;
import tcintegrations.util.ResourceLocationHelper;

@Mod.EventBusSubscriber(modid="tcintegrations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ToolEventHandler {
    private static final TinkerDataCapability.ComputableDataKey<LastTick> LAST_TICK = ToolEventHandler.createKey("last_tick", LastTick::new);

    @SubscribeEvent
    static void onLivingUpdate(LivingEvent.LivingTickEvent event) {
        ItemStack helmet;
        LivingEntity living = event.getEntity();
        if (!living.m_5833_() && !living.f_19853_.m_5776_() && living.m_6084_() && !(helmet = living.m_6844_(EquipmentSlot.HEAD)).m_41619_() && helmet.m_204117_(TinkerTags.Items.HELMETS)) {
            ToolStack tool = ToolStack.from((ItemStack)helmet);
            for (ModifierEntry entry : tool.getModifierList()) {
                IArmorCrouchModifier crouchModifier = (IArmorCrouchModifier)entry.getHook(TCIntegrationHooks.CROUCH);
                if (living.m_6047_() || living.m_6067_()) {
                    crouchModifier.onCrouch((IToolStackView)tool, entry.getLevel(), living);
                    continue;
                }
                crouchModifier.onStand(living);
            }
        }
    }

    @SubscribeEvent
    static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        ItemStack boots;
        LivingEntity living = event.getEntity();
        if (!living.m_5833_() && !living.f_19853_.m_5776_() && living.m_6084_() && !(boots = living.m_6844_(EquipmentSlot.FEET)).m_41619_() && boots.m_204117_(TinkerTags.Items.BOOTS)) {
            ToolStack tool = ToolStack.from((ItemStack)boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                ((IArmorJumpModifier)entry.getHook(TCIntegrationHooks.JUMP)).onJump((IToolStackView)tool, living);
            }
        }
    }

    @SubscribeEvent
    static void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        Player player;
        Player player2 = player = event.getEntity() != null ? event.getEntity() : null;
        if (player != null) {
            if (player.getCapability(TinkerDataCapability.CAPABILITY).filter(data -> ((LastTick)data.computeIfAbsent(LAST_TICK)).update(player)).isEmpty()) {
                return;
            }
            ItemStack stack = event.getItemStack();
            if (player.m_36335_().m_41519_(stack.m_41720_())) {
                return;
            }
            ToolStack tool = ToolStack.from((ItemStack)stack);
            List modifiers = tool.getModifierList();
            modifiers.forEach(modifierEntry -> {
                if (ModList.get().isLoaded("iceandfire") && modifierEntry.getId().equals((Object)TCIntegrationsModifiers.PHANTASMAL_MODIFIER.getId())) {
                    player.m_5496_(SoundEvents.f_12609_, 1.0f, 1.0f);
                    NetworkHandler.INSTANCE.sendToServer((Object)new LaunchGhostSword());
                }
            });
        }
    }

    private static <T> TinkerDataCapability.ComputableDataKey<T> createKey(String name, Supplier<T> constructor) {
        return TinkerDataCapability.ComputableDataKey.of((ResourceLocation)ResourceLocationHelper.resource(name), constructor);
    }

    private static class LastTick {
        private long lastTick = 0L;

        private LastTick() {
        }

        private boolean update(Player player) {
            if ((long)player.f_19797_ >= this.lastTick + 4L) {
                this.lastTick = player.f_19797_;
                return true;
            }
            return false;
        }
    }
}

